<?php
session_start();
if (!isset($_SESSION['loggedIn']) || $_SESSION['loggedIn'] !== true) {
    // يمكن عرض رسالة أو التوجيه إلى login.html
    header("Location: login.php?error=unauthorized");
    exit;
}
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Swag Gold</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link rel="stylesheet" href="swagcss/data.css">
</head>

<body>
    <!-- <script>
        // Check if the user is logged in from localStorage
        if (localStorage.getItem('isLoggedIn') !== 'true') {
            // If not logged in, redirect to login page
            window.location.href = 'login.html';
        }
    </script> -->
    <section class="data">
        <div class="data-save">
            <div class="wrapper">
                <form id="form">
                    <div class="input-wrapper">
                        <input type="number" id="gold18" name="gold18" class="input-field" required>
                        <label for="gold18" class="label">زيادة قيمة جرام الذهب 18 بمقدار</label>
                        <p>بالريال السعودي</p>
                    </div>
                    <div class="input-wrapper">
                        <input type="number" id="gold21" name="gold21" class="input-field" required>
                        <label for="gold21" class="label">زيادة قيمة جرام الذهب 21 بمقدار</label>
                        <p>بالريال السعودي</p>
                    </div>
                    <div class="input-wrapper">
                        <input type="number" id="gold24" name="gold24" class="input-field" required>
                        <label for="gold24" class="label">زيادة قيمة جرام الذهب 24 بمقدار</label>
                        <p>بالريال السعودي</p>
                    </div>
                    <div class="input-wrapper">
                        <input type="number" id="ounce" name="ounce" class="input-field" required>
                        <label for="ounce" class="label">زيادة قيمة جرام الذهب الأونصة بمقدار</label>
                        <p>بالدولار الأمريكي</p>
                    </div>
                    <div class="input-wrapper">
                        <input type="number" id="silver" name="silver" class="input-field" required>
                        <label for="silver" class="label">زيادة قيمة جرام الفضة بمقدار</label>
                        <p>بالدولار الأمريكي</p>
                    </div>
                    <button type="submit" class="save">حفظ البيانات</button>
                </form>
            </div>
        </div>
    </section>
    <script>
        document.getElementById("form").addEventListener("submit", function(event) {
            event.preventDefault(); // منع إعادة تحميل الصفحة

            // جمع القيم المدخلة في الفورم
            let formData = new FormData(this);

            // إرسال البيانات عبر AJAX إلى `save_data.php`
            fetch("save_data.php", {
                method: "POST",
                body: formData
            })
            .then(response => response.text())
            .then(data => {
                if (data.trim() === "success") {
                    alert("تم حفظ البيانات بنجاح! 🎉");
                    document.getElementById("form").reset(); // إعادة تعيين الفورم
                } else {
                    alert("حدث خطأ أثناء الحفظ، حاول مرة أخرى!");
                }
            })
            .catch(error => console.error("خطأ في الطلب:", error));
        });

        
        window.addEventListener('load', function() {
            // Send an AJAX request to the PHP script to fetch data
            fetch("get_data.php?t=" + new Date().getTime())
                .then(response => response.json())  // Parse the JSON response
                .then(data => {
                    if (data.length > 0) {
                        // Example: Display the data inside elements on the page
                        document.getElementById('gold18').value = data[0].gold18;
                        document.getElementById('gold21').value = data[0].gold21;
                        document.getElementById('gold24').value = data[0].gold24;
                        document.getElementById('ounce').value = data[0].ounce;
                        document.getElementById('silver').value = data[0].silver;

                    } else {
                        alert("No data available!");
                    }
                })
                .catch(error => console.error('Error fetching data:', error));
        });

    </script>
</body>
</html>
