// NEW

            // TradingView Widget END

            const apiUrl    = "https://www.goldapi.io/api/XAU/SAR";            
            const apiXAUUrl = "https://www.goldapi.io/api/XAU/USD";
            const apiXAGUrl = "https://www.goldapi.io/api/XAG/USD";

            const apiKey    = "goldapi-l78xsm80oefo0-io";


            let previousPrice24K = null;
            let previousPrice21K = null;
            let previousPrice18K = null;
            const swagFee = {
                                gold18: 0,
                                gold21: 0,
                                gold24: 0,
                                ounce : 0,
                                silver: 0
                            };

            async function getGoldFees() {
                try {
                    const response = await fetch("get_gold_fees.php?t=" + new Date().getTime()); // Calling PHP to get the fees
                    if (response.ok) {
                        const data = await response.json();

                        // Check if all required fields are available and valid
                        if (data && data.gold18 !== undefined && data.gold21 !== undefined && data.gold24 !== undefined && data.ounce !== undefined && data.silver !== undefined) {
                            swagFee.gold18 = data.gold18;
                            swagFee.gold21 = data.gold21;
                            swagFee.gold24 = data.gold24;
                            swagFee.ounce = data.ounce;
                            swagFee.silver = data.silver;
                        } else {
                            console.error('Error: Invalid data from the server. Missing gold prices.');
                            
                            // Optional: Set default values for the fees in case of invalid data
                            swagFee.gold18 = 0;
                            swagFee.gold21 = 0;
                            swagFee.gold24 = 0;
                            swagFee.ounce = 0;
                            swagFee.silver = 0;
                        }
                    } else {
                        console.error('Error fetching swag fee:', response.statusText);
                    }
                } catch (error) {
                    console.error('Error fetching swag fee:', error);
                    
                    // Optional: Set default values for the fees in case of a network or fetch error
                    swagFee.gold18 = 0;
                    swagFee.gold21 = 0;
                    swagFee.gold24 = 0;
                    swagFee.ounce  = 0;
                    swagFee.silver = 0;
                }
            }

            getGoldFees();
            setInterval(getGoldFees, 3000);
           

            async function getGoldPrice() {
                try {
                    const headers = new Headers({
                        "x-access-token": apiKey,
                        "Content-Type": "application/json"
                    });
                    const response = await fetch(apiUrl, { method: 'GET', headers });
                    if (!response.ok) throw new Error('Network response was not ok');
                    const data = await response.json();
                    
                    let price24K = Number(data.price_gram_24k) || 0;
                    let price21K = Number(data.price_gram_21k) || 0;
                    let price18K = Number(data.price_gram_18k) || 0;
                    
                    let feeGold24 = Number(swagFee.gold24) || 0;
                    let feeGold21 = Number(swagFee.gold21) || 0;
                    let feeGold18 = Number(swagFee.gold18) || 0;
                    
                    let change24K = price24K + feeGold24;
                    let change21K = price21K + feeGold21;
                    let change18K = price18K + feeGold18;
                    
                    // Compare old and new values for 24K
                    if (previousPrice24K !== null) {
                        if (change24K > previousPrice24K) {
                            updatePriceDisplay('gold-price-region24', change24K, "up", "green");
                        } else if (change24K < previousPrice24K) {
                            updatePriceDisplay('gold-price-region24', change24K, "down", "red");
                        } else {
                            updatePriceDisplay('gold-price-region24', change24K, "no-change", "green");
                        }
                    } else {
                        updatePriceDisplay('gold-price-region24', change24K, "no-change", "green");
                    }

                    // Compare old and new values for 21K
                    if (previousPrice21K !== null) {
                        if (change21K > previousPrice21K) {
                            updatePriceDisplay('gold-price-region21', change21K, "up", "green");
                        } else if (change21K < previousPrice21K) {
                            updatePriceDisplay('gold-price-region21', change21K, "down", "red");
                        } else {
                            updatePriceDisplay('gold-price-region21', change21K, "no-change", "green");
                        }
                    } else {
                        updatePriceDisplay('gold-price-region21', change21K, "no-change", "green");
                    }

                    // Compare old and new values for 18K
                    if (previousPrice18K !== null) {
                        if (change18K > previousPrice18K) {
                            updatePriceDisplay('gold-price-region18', change18K, "up", "green");
                        } else if (change18K < previousPrice18K) {
                            updatePriceDisplay('gold-price-region18', change18K, "down", "red");
                        } else {
                            updatePriceDisplay('gold-price-region18', change18K, "no-change", "green");
                        }
                    } else {
                        updatePriceDisplay('gold-price-region18', change18K, "no-change", "green");
                    }

                    // Update the previous price for the next comparison
                    previousPrice24K = change24K;
                    previousPrice21K = change21K;
                    previousPrice18K = change18K;

                } catch (error) {
                    console.error('Error fetching gold price:', error);
                }
            }

            // Helper function to update the price display
            function updatePriceDisplay(regionId, price, direction, color) {
                let arrow = "";
                let arrowColor = "";
                
                if (direction === "up") {
                    arrow = "swagimgs/top.svg";
                    arrowColor = "green";
                } else if (direction === "down") {
                    arrow = "swagimgs/down.svg";
                    arrowColor = "red";
                } else {
                    arrow = "swagimgs/top.svg";
                    arrowColor = "green";
                }

                document.getElementById(regionId).innerHTML = 
                    `<h2 style="color: #bea03c; margin: 5px; ">Gold ${regionId.includes('24') ? '24K' : regionId.includes('21') ? '21K' : regionId.includes('18') ? '18K':''}</h2>
                    <div class="price-up" style="display: flex; align-items: center; justify-content: center;">
                        <p class="price" style="color: ${color}; font-size: 20px; font-weight: 800; padding-right: 5px;">${price.toFixed(2)}</p>
                        <img src="${arrow}" width="15" height="20">
                    </div>
                    <img src="swagimgs/sar.svg" width="30" height="25">`;
            }

            
            setInterval(getGoldPrice, 5000);
            getGoldPrice();

            /*----- Ounce  XAU GOLD USD -------*/

            
            let previousounce = null;

            const prevclose = "prevclose";
            const opening = "opening";
            
            async function getGoldouncePrice() {
                try {
                    const headers = new Headers({
                        "x-access-token": apiKey,
                        "Content-Type": "application/json"
                    });
            
                    const response = await fetch(apiXAUUrl, { method: 'GET', headers });
                    if (!response.ok) throw new Error('Network response was not ok');
            
                    const data = await response.json();
            
                    let priceounce    = Number(data.price) || 0;
                    let prev_close    = Number(data.prev_close_price) || 0;
                    let opening_price = Number(data.open_price) || 0;
                    let feeounce      = Number(swagFee.ounce) || 0;
            
                    let changeXAU = priceounce + feeounce;
            
                    // Compare old and new values
                    if (previousounce !== null) {
                        if (changeXAU > previousounce) {
                            updateouncePriceDisplay('goldsounces', changeXAU, "up", "green");
                        } else if (changeXAU < previousounce) {
                            updateouncePriceDisplay('goldsounces', changeXAU, "down", "red");
                        } else {
                            updateouncePriceDisplay('goldsounces', changeXAU, "no-change", "green");
                        }
                    } else {
                        updateouncePriceDisplay('goldsounces', changeXAU, "no-change", "green");
                    }
            
                    // Update Prev Close
                    document.getElementById(prevclose).innerHTML =
                        `<div class="price-up" style="display: flex; align-items: center; justify-content: space-between; width: 100%;">
                            <h4 style="color: #be0707; margin: 5px;">&nbsp; Prev Close</h4>
                            <p class="price" style="font-size: 18px; font-weight: 900; padding-right: 10px;">${prev_close.toFixed(2)} $</p>
                        </div>`;
            
                    // Update Opening
                    document.getElementById(opening).innerHTML =
                        `<div class="price-up" style="display: flex; align-items: center; justify-content: space-between; width: 100%;">
                            <h4 style="color: #298b02; margin: 5px;">&nbsp; Opening</h4>
                            <p class="price" style="font-size: 18px; font-weight: 900; padding-right: 10px;">${opening_price.toFixed(2)} $</p>
                        </div>`;
            
                    previousounce = changeXAU;
            
                } catch (error) {
                    console.error('Error fetching gold Ounce price:', error);
                }
            }
            
            // Display gold price
            function updateouncePriceDisplay(ounceregionId, ounceprice, ouncedirection, ouncecolor) {
                
              let arrow = "";
                let arrowColor = "";
                
                if (ouncedirection === "up") {
                    arrow = "swagimgs/top.svg";
                    arrowColor = "green";
                } else if (ouncedirection === "down") {
                    arrow = "swagimgs/down.svg";
                    arrowColor = "red";
                } else {
                    arrow = "swagimgs/top.svg";
                    arrowColor = "green";
                }

            document.getElementById(ounceregionId).innerHTML = 
            `<img src="swagimgs/golds.png" alt="Gold Coin" class="gold-coin">
                <h2 style="color: #bea03c; margin: 5px; text-align: -webkit-left; ">&nbsp; Gold </h2>
                <div class="price-up" style="display: flex; align-items: center; justify-content: left; ">
                    <p class="price" style="font-size: 20px; font-weight: 900; padding-right: 10px; color:${ouncecolor}; ">&nbsp;&nbsp; ${ounceprice.toFixed(2)}</p>
                    <img src="${arrow}" width="15" height="20">
                </div>`; 
                
                
                
            }
            
            
            
            
            
            // Start polling
            getGoldouncePrice();
            setInterval(getGoldouncePrice, 5000);


            /*----- Ounce  XAG-------*/

                        
            let previouXAGsounce = null;

            async function getsilverouncePrice() {
                try {
                    const headers = new Headers({
                        "x-access-token": apiKey,
                        "Content-Type": "application/json"
                    });
                    const response = await fetch(apiXAGUrl, { method: 'GET', headers });
                    if (!response.ok) throw new Error('Network response was not ok');
                    const data = await response.json();
                    
                    let pricesilver = Number(data.price) || 0;
                    
                    let feesilver = Number(swagFee.silver) || 0;
                    
                    let changeXAG = pricesilver + feesilver ;

                    // Compare old and new values for 24K
                    if (previouXAGsounce !== null) {
                        if (changeXAG > previouXAGsounce) {
                            updatesilverouncePriceDisplay('silversounces', changeXAG, "up", "green");
                        } else if (changeXAG < previouXAGsounce) {
                            updatesilverouncePriceDisplay('silversounces', changeXAG, "down", "red");
                        } else {
                            updatesilverouncePriceDisplay('silversounces', changeXAG, "no-change", "green");
                        }
                    } else {
                        updatesilverouncePriceDisplay('silversounces', changeXAG, "no-change", "green");
                    }

                    
                    // Update the previous price for the next comparison
                    previouXAGsounce = changeXAG;

                } catch (error) {
                    console.error('Error fetching Silver price:', error);
                }
            }

            // Helper function to update the price display
            function updatesilverouncePriceDisplay(silverregionId, silverprice, silverdirection, silvercolor) {
                let arrow = "";
                let arrowColor = "";
                
                if (silverdirection === "up") {
                    arrow = "swagimgs/top.svg";
                    arrowColor = "green";
                } else if (silverdirection === "down") {
                    arrow = "swagimgs/down.svg";
                    arrowColor = "red";
                } else {
                    arrow = "swagimgs/top.svg";
                    arrowColor = "green";
                }

                document.getElementById(silverregionId).innerHTML =     
                `<img src="swagimgs/silver.png" alt="Gold Coin" class="gold-coin">
                <h2 style="color: #7f807e; margin: 5px; text-align: -webkit-left; ">&nbsp; Silver </h2>
                <div class="price-up" style="display: flex; align-items: center; justify-content: left;">
                    <p class="price" style="font-size: 20px; font-weight: 900; padding-right: 10px; color:${silvercolor};">
                            &nbsp;&nbsp; ${silverprice.toFixed(2)} $
                    </p>
                    <img src="${arrow}" width="15" height="20">
                </div> `;
                    
            }
            

            getsilverouncePrice();                       
            setInterval(getsilverouncePrice, 5000);



