<?php
session_start();
session_unset();
session_destroy();
session_start();
include 'config.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = $_POST["name"];
    $password = $_POST["password"];

    $sql = "SELECT * FROM users WHERE username = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($row = $result->fetch_assoc()) {
        if (password_verify($password, $row["password"])) {
            $_SESSION["username"] = $username;
            $_SESSION['loggedIn'] = true;
            header("Location: data.php");
            exit();
        } else {
            echo "Invalid password!";
        }
    } else {
        echo "User not found!";
    }
}
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Swag gold</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link rel="stylesheet" href="swagcss/Style.css">
</head>

<body>
    <section class="login">
       <div class="log-in">
        <div class="login-img">
            <img src="swagimgs/Group 42.png" alt="Image login">
        </div>
        <div class="wrapper">
            <form id="form" action="login.php" method="post">
                <h2>تسجيل الدخول</h2>
                <div class="input-box">
                    <input type="text" name="name" id="name" placeholder="ادخل اسم المستخدم" required>
                    <i class="fa-solid fa-user"></i>
                </div>
                <div class="input-box">
                    <input type="password" name="password" id="password" placeholder="ادخل كلمة المرور" required>
                    <i class="fa-solid fa-unlock"></i>
                </div>
                

                <div class="btn">
                    <button type="" class="cancel">إلغاء</button>
                    <button type="submit" class="logg">تسجيل الدخول</button>
                </div>

            </form>
        </div>
       </div>
    </section>


 <!-- JS  -->
    <script src="swagjs/main.js"></script>
</body>
</html>